<?xml version="1.0"?>
<!-- Written by Peter Mertens "peter@pmertens.de" -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
	<xsl:import href="depotbestand-html-incl.xsl"/>
	<xsl:import href="umsaetze-html-incl.xsl"/>
	<xsl:template match="/Kundendaten">
		<h4>Geburtsdatum: <xsl:value-of select="Geburtsdatum"/>
			<xsl:if test='Geschlecht="m"'>, maennlich, </xsl:if>
			<xsl:if test='Geschlecht="w"'>, weiblich, </xsl:if>
			<xsl:value-of select="Familienstand"/>, <xsl:value-of select="Kundenart"/>
		</h4>
		<xsl:if test='Adresse!=""'>
			<table bgcolor="#C0C0C0" border="0" cellpadding="0" cellspacing="0" width="100%">
				<tr>
					<td width="100%">
						<table bgcolor="#C0C0C0" cellpadding="0" border="0" width="50%" cellspacing="10">
							<xsl:apply-templates select="Adresse"/>
						</table>
					</td>
				</tr>
			</table>
			<hr/>
		</xsl:if>
		<table bgcolor="#C0C0C0" border="0" cellpadding="0" cellspacing="0" width="100%">
			<tr>
				<td width="100%">
					<xsl:if test='Konto!=""'>
						<table bgcolor="#C0C0C0" cellpadding="0" border="0" width="100%" cellspacing="10">
							<xsl:apply-templates select="Konto" mode="1">
								<xsl:sort select="Kontoart"/>
								<xsl:sort select="Kontonummer"/>
							</xsl:apply-templates>
						</table>
						<hr/>
						<xsl:apply-templates select="Konto" mode="2">
							<xsl:sort select="Kontoart"/>
							<xsl:sort select="Kontonummer"/>
						</xsl:apply-templates>
					</xsl:if>
				</td>
			</tr>
		</table>
	</xsl:template>
	<xsl:template match="Adresse">
		<xsl:if test="position()=1">
			<font color="#FF0000">Adresse</font>
			<tr>
				<td valign="top">
					<font color="#FF0000">Postleitzahl</font>
				</td>
				<td valign="top">
					<font color="#FF0000">Wohnort</font>
				</td>
				<td valign="top">
					<font color="#FF0000">Straße</font>
				</td>
				<td valign="top">
					<font color="#FF0000">Datum-ab</font>
				</td>
			</tr>
		</xsl:if>
		<tr>
			<td valign="top">
				<xsl:value-of select="Postleitzahl"/>
			</td>
			<td valign="top">
				<xsl:value-of select="Ort"/>
			</td>
			<td valign="top">
				<xsl:value-of select="Strasse"/>
			</td>
			<td valign="top">
				<xsl:value-of select="Datum-ab"/>
			</td>
		</tr>
	</xsl:template>
	<xsl:template match="Konto" mode="1">
		<xsl:if test="position()=1">
			<tr>
				<td valign="top">
					<font color="#FF0000">Kontoart</font>
				</td>
				<td valign="top">
					<font color="#FF0000">Kontonummer</font>
				</td>
				<td valign="top">
					<font color="#FF0000">Eroeffnungsdatum</font>
				</td>
				<td valign="top">
					<font color="#FF0000">Saldo</font>
				</td>
				<td valign="top">
					<font color="#FF0000">Waehrung</font>
				</td>
				<td valign="top">
					<font color="#FF0000">Darlehenstyp</font>
				</td>
			</tr>
		</xsl:if>
		<tr>
			<td valign="top">
				<xsl:value-of select="Kontoart"/>
			</td>
			<td valign="top">
				<xsl:value-of select="Kontonummer"/>
			</td>
			<td valign="top">
				<xsl:value-of select="Eroeffnungsdatum"/>
			</td>
			<xsl:choose>
				<xsl:when test='Saldo!=""'>
					<td valign="top">
						<xsl:value-of select="format-number(Saldo[1]/Betrag,'##,##0.00')"/>
					</td>
				</xsl:when>
				<xsl:otherwise>
					<td valign="top"/>
				</xsl:otherwise>
			</xsl:choose>
			<td valign="top">
				<xsl:value-of select="Waehrung"/>
			</td>
			<td valign="top">
				<xsl:value-of select="Darlehenstyp"/>
			</td>
		</tr>
		<xsl:if test="position()=last()">
			<tr>
				<td valign="top">
					<font color="#FF0000">akumulierte</font>
				</td>
				<td valign="top">
					<font color="#FF0000">Salden:</font>
				</td>
				<td valign="top"/>
				<td valign="top">
					<font color="#FF0000">
						<xsl:value-of select="format-number(sum(../Konto/Saldo[1]/Betrag),'##,##0.00')"/>
					</font>
				</td>
			</tr>
		</xsl:if>
	</xsl:template>
	<xsl:template match="Konto" mode="2">
		<xsl:if test='Depotbestand!="" or Zinssatz!="" or Umsatz!=""'>
			<hr/>Daten der Kontoart <font color="#FF0000">
				<xsl:value-of select="Kontoart"/>
			</font> mit der Kontonummer <font color="#FF0000">
				<xsl:value-of select="Kontonummer"/>
			</font>
			<br/>
			<xsl:if test='Depotbestand!=""'>
				<table bgcolor="#C0C0C0" cellpadding="0" border="0" width="100%" cellspacing="10">
					<xsl:apply-templates select="Depotbestand/Verweis"/>
				</table>
				<hr/>
			</xsl:if>
			<xsl:if test='Zinssatz!=""'>
				<table bgcolor="#C0C0C0" cellpadding="0" border="0" width="100%" cellspacing="10">
					<xsl:apply-templates select="Zinssatz"/>
				</table>
				<hr/>
			</xsl:if>
			<xsl:if test='Umsaetze!=""'>
				<table bgcolor="#C0C0C0" cellpadding="0" border="0" width="100%" cellspacing="10">
					<xsl:apply-templates select="Umsaetze/Verweis">
						<xsl:sort select="Umsaetze/Verweis/@Stichtag"/>
					</xsl:apply-templates>
				</table>
				<hr/>
			</xsl:if>
		</xsl:if>
	</xsl:template>
	<xsl:template match="Konto/Depotbestand/Verweis">
		<xsl:if test="position()=1">
			<font color="#FF0000">Bestände des Depot</font>
			<tr>
				<td valign="top">
					<font color="#FF0000">Papiertyp</font>
				</td>
				<td valign="top">
					<font color="#FF0000">Kennnummer</font>
				</td>
				<td valign="top">
					<font color="#FF0000">Bezeichnung</font>
				</td>
				<td valign="top">
					<font color="#FF0000">Stueckzahl</font>
				</td>
				<td valign="top">
					<font color="#FF0000">Nennwert</font>
				</td>
				<td valign="top">
					<font color="#FF0000">Kurs</font>
				</td>
				<td valign="top">
					<font color="#FF0000">Währung</font>
				</td>
				<td valign="top">
					<font color="#FF0000">Wert</font>
				</td>
				<td valign="top">
					<font color="#FF0000">Zinsfluss</font>
				</td>
			</tr>
		</xsl:if>
		<tr>
			<td valign="top">
				<font color="#FF0000">Stichtag</font>
			</td>
			<td valign="top">
				<font color="#FF0000">
					<xsl:value-of select="@Stichtag"/>
				</font>
			</td>
		</tr>
		<xsl:variable name="link">
			<xsl:value-of select="@href"/>
		</xsl:variable>
		<xsl:apply-templates select="document($link)"/>
	</xsl:template>
	<xsl:template match="Konto/Zinssatz">
		<xsl:if test="position()=1">
			<font color="#FF0000">Zinssätze</font>
			<tr>
				<td valign="top">
					<font color="#FF0000">Soll</font>
				</td>
				<td valign="top">
					<font color="#FF0000">Ueberziehung</font>
				</td>
				<td valign="top">
					<font color="#FF0000">Haben</font>
				</td>
				<td valign="top">
					<font color="#FF0000">Kreditlinie</font>
				</td>
				<td valign="top">
					<font color="#FF0000">Datum-ab</font>
				</td>
			</tr>
		</xsl:if>
		<tr>
			<xsl:choose>
				<xsl:when test='Soll!=""'>
					<td valign="top">
						<xsl:value-of select="format-number(Soll,'0.00 %')"/>
					</td>
				</xsl:when>
				<xsl:otherwise>
					<td valign="top"/>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:choose>
				<xsl:when test='Ueberziehung!=""'>
					<td valign="top">
						<xsl:value-of select="format-number(Ueberziehung,'0.00 %')"/>
					</td>
				</xsl:when>
				<xsl:otherwise>
					<td valign="top"/>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:choose>
				<xsl:when test='Haben!=""'>
					<td valign="top">
						<xsl:value-of select="format-number(Haben,'0.00 %')"/>
					</td>
				</xsl:when>
				<xsl:otherwise>
					<td valign="top"/>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:choose>
				<xsl:when test='Kreditlinie!=""'>
					<td valign="top">
						<xsl:value-of select="format-number(Kreditlinie,'##,##0.00')"/>
					</td>
				</xsl:when>
				<xsl:otherwise>
					<td valign="top"/>
				</xsl:otherwise>
			</xsl:choose>
			<td valign="top">
				<xsl:value-of select="Datum-ab"/>
			</td>
		</tr>
	</xsl:template>
	<xsl:template match="Konto/Umsaetze/Verweis">
		<xsl:if test="position()=1">
			<font color="#FF0000">Kontenumsätze</font>
			<tr>
				<td valign="top">
					<font color="#FF0000">Betrag</font>
				</td>
				<td valign="top">
					<font color="#FF0000">Umsatzart</font>
				</td>
				<td valign="top">
					<font color="#FF0000">Wertstellungstag</font>
				</td>
				<td valign="top">
					<font color="#FF0000">Buchungstext</font>
				</td>
				<td valign="top">
					<font color="#FF0000">Fremdkonto</font>
				</td>
				<td valign="top">
					<font color="#FF0000">Fremd-Bankleitzahl</font>
				</td>
			</tr>
		</xsl:if>
		<xsl:variable name="link">
			<xsl:value-of select="@href"/>
		</xsl:variable>
		<xsl:apply-templates select="document($link)"/>
	</xsl:template>
</xsl:stylesheet>
